#include <iostream>
#include <vector>
#include <algorithm>
using namespace std;

#define MAXN 100010

int poderes[MAXN][MAXN], resp[MAXN][MAXN], ativo[MAXN][MAXN], indice[MAXN][MAXN];
int pai[MAXN], soma[MAXN];
int dx[] = {0, 1, 0, -1};
int dy[] = {1, 0, -1, 0};
vector<vector<int>> componente(MAXN);

struct Celula {
    int linha, coluna, poder;
    Celula(int l, int c, int p) : linha(l), coluna(c), poder(p) {}
};

bool cmp(Celula a, Celula b) {
    return a.poder < b.poder;
}

int find(int v) {
    if (pai[v] == v) return v;
    pai[v] = find(pai[v]);  // Compressão de caminho
    return pai[v];
}

void une(int a, int b) {
    a = find(a);
    b = find(b);

    if (a == b) return;

    if (componente[a].size() > componente[b].size()) {
        swap(a, b);
    }

    componente[b].insert(componente[b].end(), componente[a].begin(), componente[a].end());
    pai[a] = b;
    soma[b] += soma[a];
    componente[a].clear();
}

int main() {
    while (true) {
        int n, m;
        cin >> n >> m;

        if (n == 0 && m == 0) break;

        vector<Celula> celulas;
        int idCounter = 0;

        for (int i = 0; i < n; i++) {
            for (int j = 0; j < m; j++) {
                int p;
                cin >> p;
                poderes[i][j] = p;
                Celula nova(i, j, p);
                celulas.push_back(nova);
                indice[i][j] = ++idCounter;
                ativo[i][j] = 0;
                resp[i][j] = 0;
            }
        }

        sort(celulas.begin(), celulas.end(), cmp);

        for (int i = 0; i < n * m; i++) {
            Celula c = celulas[i];
            int l = c.linha, c1 = c.coluna, p = c.poder;
            ativo[l][c1] = 1;
            int id = indice[l][c1] - 1;

            for (int k = 0; k < 4; k++) {
                int vizl = l + dx[k];
                int vizc = c1 + dy[k];
                if (vizl < 0 || vizl >= n || vizc < 0 || vizc >= m) continue;
                if (ativo[vizl][vizc] == 0) continue;

                int vizid = indice[vizl][vizc] - 1;
                if (p <= soma[vizid]) {
                    une(id, vizid);
                } else {
                    for (int t = 0; t < componente[vizid].size(); t++) {
                        resp[componente[vizid][t].linha][componente[vizid][t].coluna] = soma[vizid];
                    }
                    componente[vizid].clear();
                    une(vizid, id);
                }
            }
        }

        for (int i = 0; i < n; i++) {
            for (int j = 0; j < m; j++) {
                cout << resp[i][j] << " ";
            }
            cout << endl;
        }
    }
    return 0;
}
